//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using CSCashSales.data_objects;

namespace CSCashSales.user_interface
{
  /// <summary>
  /// List All Sales form.
  /// </summary>
  /// <TgData>
  /// </TgData>
  public class CashListForm : System.Windows.Forms.Form
  {
    /// <summary>
    ///    Required designer variable.
    /// </summary>
    private System.ComponentModel.Container components;
		private System.Windows.Forms.Button m_btnClose;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ListView m_lvwList;

		/// <summary>
		/// A reference to cash sale container.
		/// </summary>
		private ICashSaleContainer m_objCashBag;

		/// <summary>
		/// Constructor.
		/// </summary>
		/// <param name="objCashBag"> a reference to cash sale container </param>
    public CashListForm( ICashSaleContainer objCashBag )
    {
      //
      // Required for Windows Form Designer support
      //
      InitializeComponent();

			m_objCashBag = objCashBag;
			fillList();
        }

      /// <summary>
      ///    Clean up any resources being used.
      /// </summary>
      protected override void Dispose( bool disposing )
      {
        if( disposing )
        {
          if(components != null)
          {
            components.Dispose();
          }
        }
        base.Dispose( disposing );
      }

        /// <summary>
        ///    Required method for Designer support - do not modify
        ///    the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container ();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader ();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader ();
			this.m_lvwList = new System.Windows.Forms.ListView ();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader ();
			this.m_btnClose = new System.Windows.Forms.Button ();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader ();
			//@this.TrayHeight = 0;
			//@this.TrayLargeIcon = false;
			//@this.TrayAutoArrange = true;
			columnHeader2.Text = "Total";
			columnHeader2.Width = 90;
			columnHeader2.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			columnHeader1.Text = "Date";
			columnHeader1.Width = 153;
			columnHeader1.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
			m_lvwList.Location = new System.Drawing.Point (8, 8);
			m_lvwList.Size = new System.Drawing.Size (472, 200);
			//m_lvwList.View = System.Windows.Forms.View.Report;
			m_lvwList.View = System.Windows.Forms.View.Details;
			m_lvwList.ForeColor = System.Drawing.SystemColors.WindowText;
			m_lvwList.GridLines = true;
			m_lvwList.TabIndex = 0;
			//m_lvwList.Columns.All = new System.Windows.Forms.ColumnHeader[4] {this.columnHeader1, this.columnHeader2, this.columnHeader3, this.columnHeader4};
			m_lvwList.Columns.Add(this.columnHeader1);
			m_lvwList.Columns.Add(this.columnHeader2);
			m_lvwList.Columns.Add(this.columnHeader3);
			m_lvwList.Columns.Add(this.columnHeader4);
			columnHeader3.Text = "Subtotal";
			columnHeader3.Width = 90;
			columnHeader3.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_btnClose.Location = new System.Drawing.Point (408, 224);
			m_btnClose.Size = new System.Drawing.Size (75, 23);
			m_btnClose.TabIndex = 1;
			m_btnClose.Text = "Close";
			m_btnClose.Click += new System.EventHandler (this.m_btnClose_Click);
			columnHeader4.Text = "Tax";
			columnHeader4.Width = 90;
			columnHeader4.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.Text = "List All Sales";
			this.AutoScaleBaseSize = new System.Drawing.Size (5, 13);
			this.ClientSize = new System.Drawing.Size (488, 253);
			this.Controls.Add (this.m_btnClose);
			this.Controls.Add (this.m_lvwList);
		}

		/// <summary>
		/// An event handler of Close button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnClose_Click (object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Fills the list of cash sales.
		/// </summary>
		private void fillList() 
		{
			//ListItem item = null;
			ListViewItem item = null;
			for(int row=0; row < m_objCashBag.getCount(); row++)
			{
				ICashSale sale = m_objCashBag.getCashSaleAt(row);
				//
				/*
				item = m_lvwList.InsertItem( row, sale.getSaleDate().ToString() );
				item.SetSubItem( 0, Utils.AsCurrency(sale.getTotal()) );
				item.SetSubItem( 1, Utils.AsCurrency(sale.getSubTotal()) );
				item.SetSubItem( 2, Utils.AsCurrency(sale.getTax()) );
				*/
				item = m_lvwList.Items.Add(sale.getSaleDate().ToString());
				item.SubItems.Add(Utils.AsCurrency(sale.getTotal()) );
				item.SubItems.Add(Utils.AsCurrency(sale.getSubTotal()) );
				item.SubItems.Add(Utils.AsCurrency(sale.getTax()) );
			}
			/*
			item = m_lvwList.InsertItem( m_objCashBag.getCount(), "SUMMARY" );
			item.SetSubItem( 0, Utils.AsCurrency(m_objCashBag.getTotal()) );
			item.SetSubItem( 1, Utils.AsCurrency(m_objCashBag.getSubTotal()) );
			item.SetSubItem( 2, Utils.AsCurrency(m_objCashBag.getTax()) );
			*/
			item = m_lvwList.Items.Add("SUMMARY");
			item.SubItems.Add(Utils.AsCurrency(m_objCashBag.getTotal()) );
			item.SubItems.Add(Utils.AsCurrency(m_objCashBag.getSubTotal()) );
			item.SubItems.Add(Utils.AsCurrency(m_objCashBag.getTax()) );
		}

    }
}
